;----------------------------------------------------------------------
;
;  System printer configuration file
;  Use on Windows to print to system printer
;
;  Current Revision:
;  $RCSfile: printer.plt,v $
;  $Revision: 7.37.4.7 $  $Date: 2004/02/06 20:55:47 $
;
;----------------------------------------------------------------------

;======================================================================
;
;   >>>>> WARNING  WARNING  WARNING  WARNING  WARNING  WARNING  <<<<<
;  
;  Plotter driver configuration files are now stored in two directories:
;
;    $(_USTN_WORKSPACEROOT)/System/plotdrv/
;    $(_USTN_WORKSPACEROOT)/Standards/plotdrv/
;
;  System/plotdrv/ should be reserved for .plt files delivered by
;  MicroStation and other Bentley products. Standards/plotdrv/ is
;  provided as a place for you to store customized .plt files. To
;  simplify plotter selection from the Plot dialog, you may also
;  elect to store frequently-used .plt files in Standards/plotdrv/
;  even if you do not customize them.
;
;  To minimize the risk of losing your changes during a product
;  reinstallation, do not edit the files in the System/plotdrv/
;  directory. Instead, copy the necessary files to Standards/plotdrv/
;  and edit them there. If the .plt file depends on other files, such
;  as PostScript prolog (*.pro) files, copy them to the same directory.
;
;======================================================================

; Required record, must precede any "pen" records.
; You may produce non-halftoned monochrome output on a color device by
; setting "num_pens = 1".
num_pens = 255

; When thin vector elements with highly saturated colors are half-toned,
; they can be extraordinarily difficult to see.  You may wish to
; assign such element colors to a specific pen.  That pen can in turn
; be assigned an RGB value of your choice.  Refer to the Printing
; Guide documentation for more information on the "pen" record.

model = sysprinter
stroke_tolerance = 10   ; unitless num 0 < tol < 10
autocenter

;default_extension/auto_incExt = '000'
;default_outFile = "$(MS_PLTFILES)plotfile.000"

;  The style records defines how the design file line codes (styles)
;  are to be plotted.  By default, values are in plotter units (resolutions).
;  Values determine pen down/up movements, where (14,42) for a dot
;  pattern leaves the pen down for 14 units and up for 42 units.  The
;  /nohardware switch causes software stroking with these values.
;  Valid units are MM, IN, or DOTS (the default)
;
;  If you are using Windows 98/ME you will want to change 'hardware' to 
;  'nohardware' in the linestyle definitions below. Otherwise it will result
;  in the inability to plot lines that have both weight and style.  This is
;  due to a limitation in the Graphics Device Interface of Windows 98/ME.
;  Note that making this change will result in larger printer output
;  from MicroStation.
;
style(1) = ( 0.35, 1.05)                            /hardware /units=MM ; style = dot
style(2) = ( 1.75, 1.05)                            /hardware /units=MM ; style = med dash
style(3) = ( 4.20, 1.40)                            /hardware /units=MM ; style = long dash
style(4) = ( 2.80, 1.05, 0.70, 1.05)                /hardware /units=MM ; style = dot-dash
style(5) = ( 1.40, 1.40)                            /hardware /units=MM ; style = short dash
style(6) = ( 2.10, 0.70, 0.70, 0.70, 0.70, 0.70)    /hardware /units=MM ; style = dash-dot-dot
style(7) = ( 2.80, 0.70, 1.40, 0.70)                /hardware /units=MM ; style = long dash - short dash

; linecap, linejoin and miter_limit
; Note: these settings do not have an effect in Win95/3.x 
;       due to a limitation in the Graphics Device Interface
;
linecap     = 1         ; 1=butt, 2=square, 4=round
linejoin    = 5         ; 2=miter/bevel, 4=round, 5=beveled
miter_limit = 1.415     ; Larger values allow longer spikes w/linejoin=2

; Specify the mapping of MicroStation line weights to line thickness on paper.
; Units are MM, IN, or DOTS (the default)
weight_strokes(mm)=(0.04, 0.186, 0.45, 0.55, 0.7, 0.8, 0.95, 0.562, \
                    0.625, 0.687, 1.500, 1.625, 1.750, 1.875, 2.000, 2.125, \
                    2.250, 2.375, 2.500, 2.625, 2.750, 2.875, 3.000, 3.125, \
                    3.250, 3.375, 3.500, 3.625, 3.750, 3.875, 4.000, 4.125)

; Remove this record if no border is desired.
; Refer to the documentation for available border qualifiers.
; border /time /filename /text_height=0.35                                                      

; Refer to the documentation for available fence_outline qualifiers.
;fence_outline

; Substitute the name of a pentable file to be loaded when this driver is selected
;pentable=\dir\file.tbl

; Refer to the documentation for sysprinter qualifiers, such as printer and form name.
sysprinter /offset=(6.35, 6.35) /units=mm

; This keyword controls the size (diameter) of points. Units are cm. 
; A value of 0, disables point drawing.
; Note that with some system printer drivers, setting this value 
; too small, may result in no point being drawn.
point_size = 0.03

; Font maps are supported for this driver.
; Refer to the documentation for the syntax of the font map records.


; The following options control printing of Raster Manager images.
; Refer to the "Printing Using Raster Manager" section of the documentation
; for descriptions of these records.
PIXEL_RESOLUTION    = 150
GRAYSCALE           = 0
BACKGROUND          = 0
CONTRAST            = 50
BRIGHTNESS          = 50
NO_RASTERREF        = 0

; The following record specifies whether type 87/88 raster elements are printed.
; This record is ignored by Raster Manager. 
NO_DGNRASTER = 0 ; 0=plot, 1=don't plot (the default is to plot).
